#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Fractal tile mosaic 2Mod01.fsh  by  Jarble
//https://www.shadertoy.com/view/wtKcRc
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//change these parameters to get different tile patterns.
#define scale 5.5
#define scale1 2.0
#define scale2 2.0
#define scale3 8.0
#define ITERATIONS 6

/*
#define scale1 1.5
#define scale2 4.0
#define scale3 8.0
#define ITERATIONS 3
*/

float fract1(float a){
    return (abs(fract(a/2.0)-.5))*2.0;
}

vec2 fract1(vec2 a){
    return (abs(fract(a/2.0)-.5))*2.0;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    fragColor = vec4(0.0);
    vec3 col;
    for(int c=0;c<3;c++){
        vec2 uv = (fragCoord*20.0-iResolution.xy)/iResolution.y/10.0;
        uv += vec2(iTime/3.0,iTime/8.0)/2.0;
        for(int i=0;i<ITERATIONS;i++)
        {
            uv = (fract1(uv/scale2)+fract1(uv/scale3/2.0))*scale1;
            uv= fract1(uv/(2.0-fract1((uv.x-uv.y)/(8.0)))-(uv/(1.7+(fract1(uv.x+uv.y))))/scale)*scale/scale1+scale1*scale;
            uv /= scale1+col.yx;
        	uv=uv.yx+col.xy;
        }
     col[c] = abs(fract(uv.y)-fract(uv.x));
	}
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

